/*Tabelle für Sonderfunktionen*/
CREATE TABLE settings
 (s_vari                varchar(70) NOT NULL PRIMARY KEY,
  s_owner               varchar(50),  --ist bisher noch nicht verwendet und ist in den Funktionen nicht berücksichtigt
  s_inha                text,
  s_num_inha            numeric(20,8) -- Länge entspr. Standard für interne Werte
 ); 

 --

/*sprachschlüssel allgemein*/

CREATE TABLE sprach
 (spr_key               VARCHAR(5) NOT NULL PRIMARY KEY
 );

/*dokumentsprache für Anschreiben, referenziert die TextNr aus Text0,
  deshalb kann ein Sprachschlüssel verschiedene Textdateien haben*/


CREATE TABLE adkspco
 (s_spco                SERIAL PRIMARY KEY,
  s_spr_key             VARCHAR(5) NOT NULL REFERENCES sprach,
  s_sprach              INTEGER,       /*TEXT NR*/
  s_bb                  VARCHAR(75)     -- Hintergrund BriefBogen (FileName)
 );


 -- [SYNCRO-TABLE] Tabellen für Sprachen
-- ACHTUNG: Bei Änderungen die Felder im Cache DM1.TextX mit anpassen.
CREATE TABLE text0
 (t_nr                  integer PRIMARY KEY,   -- [SYNCRO:SyncID]
  t_feld0               text,                  -- [SYNCRO:Deleted='*DELETED*'] deutsch
  t_kundtxt0            text,                  -- [SYNCRO:NotThisFields] alternativer Kundentext
  t_feld0_modified      timestamp(0),
  t_feld1               text,                  -- französisch
  t_kundtxt1            text,                  -- [SYNCRO:NotThisFields]
  t_feld1_modified      timestamp(0),
  t_feld2               text,                  -- frei
  t_kundtxt2            text,                  -- [SYNCRO:NotThisFields]
  t_feld2_modified      timestamp(0),
  t_feld3               text,                  -- englisch
  t_kundtxt3            text,                  -- [SYNCRO:NotThisFields]
  t_feld3_modified      timestamp(0),
  t_feld4               text,                  -- italienisch
  t_kundtxt4            text,                  -- [SYNCRO:NotThisFields]
  t_feld4_modified      timestamp(0),
  t_feld5               text,                  -- spanisch
  t_kundtxt5            text,                  -- [SYNCRO:NotThisFields]
  t_feld5_modified      timestamp(0),
  t_feld6               text,                  -- tschechisch
  t_kundtxt6            text,                  -- [SYNCRO:NotThisFields]
  t_feld6_modified      timestamp(0),
  t_feld7               text,                  -- russisch
  t_kundtxt7            text,                  -- [SYNCRO:NotThisFields]
  t_feld7_modified      timestamp(0),
  t_feld8               text,                  -- frei
  t_kundtxt8            text,                  -- [SYNCRO:NotThisFields]
  t_feld8_modified      timestamp(0),
  --
  t_modified            timestamp(0)           -- [SYNCRO:Modified]
 );

CREATE INDEX text0_nr_group ON text0 (t_nr, t_feld0) WHERE t_feld0 LIKE 'TEXT0:%';  -- für Suche der Text0-Nummernbereiche "TEXT0:%"


-- Zeitstempel für Synchronisation setzen
CREATE OR REPLACE FUNCTION text0_modified() RETURNS TRIGGER AS $$
  DECLARE
    changed BOOL;
  BEGIN
    IF current_user <> 'syncro' THEN
      changed := False;
      IF coalesce(new.t_feld0, '') <> coalesce(old.t_feld0, '') THEN  --deutsch

        -- HINWEIS DS: public. wegen FDW https://redmine.prodat-sql.de/issues/16893#note-32
        new.t_feld0_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld1, '') <> coalesce(old.t_feld1, '') THEN  --französisch
        new.t_feld1_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld2, '') <> coalesce(old.t_feld2, '') THEN  --frei
        new.t_feld2_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld3, '') <> coalesce(old.t_feld3, '') THEN  --englisch
        new.t_feld3_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld4, '') <> coalesce(old.t_feld4, '') THEN  --italienisch
        new.t_feld4_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld5, '') <> coalesce(old.t_feld5, '') THEN  --spanisch
        new.t_feld5_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld6, '') <> coalesce(old.t_feld6, '') THEN  --tschechisch
        new.t_feld6_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld7, '') <> coalesce(old.t_feld7, '') THEN  --russisch
        new.t_feld7_modified := public.currenttime();
        changed              := True;
      END IF;
      IF coalesce(new.t_feld8, '') <> coalesce(old.t_feld8, '') THEN  --frei
        new.t_feld8_modified := public.currenttime();
        changed              := True;
      END IF;
      IF changed THEN
        new.t_modified       := public.currenttime();
        PERFORM TSystem.Settings__Set('textmodified', 'T');  -- Flag für TProdatSrvService.SendLokalChangedMail
      END IF;
    END IF;
    RETURN new;
  END$$ LANGUAGE plpgsql;

  CREATE TRIGGER text0_modified
    BEFORE UPDATE
    ON text0
    FOR EACH ROW
    EXECUTE PROCEDURE text0_modified();
--

-- Infos zu allen Texten für die Synchronisation
CREATE OR REPLACE FUNCTION text0_GetSync(tnr integer) RETURNS text AS $$
  BEGIN
    RETURN
         E'***** deutsch '     || coalesce(t_feld0_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld0, '') || E'\n\n'
      || E'***** französisch ' || coalesce(t_feld1_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld1, '') || E'\n\n'
      || E'***** frei '        || coalesce(t_feld2_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld2, '') || E'\n\n'
      || E'***** englisch '    || coalesce(t_feld3_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld3, '') || E'\n\n'
      || E'***** italienisch ' || coalesce(t_feld4_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld4, '') || E'\n\n'
      || E'***** spanisch '    || coalesce(t_feld5_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld5, '') || E'\n\n'
      || E'***** tschechisch ' || coalesce(t_feld6_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld6, '') || E'\n\n'
      || E'***** russisch '    || coalesce(t_feld7_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld7, '') || E'\n\n'
      || E'***** frei '        || coalesce(t_feld8_modified::varchar || ' ', '') || E'*****\n' || coalesce(t_feld8, '')
    FROM text0
    WHERE t_nr = tnr;
  END$$ LANGUAGE plpgsql;
--